s        b   J e  4x                                     AuMT8820                        AuMT8820 MainFrame                                                                                        ViRsrc     	 	ViBoolean     	 	ViSession      ViStatus     ViInt32       ViChar[]  Z    History of MT8820 MainFrame LabWindows Driver.fp
-------------------------------------------------------------
* 01 Sep 2003 , [V3.1]
    INILEVEL? is deleted
    MCAT? is deleted
    MCFV? is deleted (see to WCDMA)
    MSTAT? is deleted (see WCDMA/GSM)
-------------------------------------------------------------
* 25 Jul 2003 , [V3.0] , New        This function performs the following initialization actions:

- Creates a newinstrument driver session.

- Opens a session to the specified device using the interface and address you specify for the Resource Name parameter.

- If the ID Query parameter is set to VI_TRUE, this function queries the instrument ID and checks that it is valid for this instrument driver.

- If the Reset parameter is set to VI_TRUE, this function resets the instrument to a known state.

- Sends initialization commands to set the instrument to the state necessary for the operation of the instrument driver.

- Returns a ViSession handle that you use to identify the instrument in all subsequent instrument driver function calls.

Note:  This function creates a new session each time you invoke it. Although you can open more than one session for the same resource, it is best not to do so.  You can use the same session in multiple program threads. 

    	J    Pass the resource name of the device to initialize.

You can also pass the name of a virtual instrument or logical name that you configure with the IVI Configuration utility.  The virtual instrument identifies a specific device and specifies the initial settings for the session.  A logical Name identifies a particular virtual instrument.

Refer to the following table below for the exact grammar to use for this parameter.  Optional fields are shown in square brackets ([]).

Syntax
------------------------------------------------------
GPIB[board]::<primary address>[::secondary address]::INSTR
VXI[board]::<logical address>::INSTR
GPIB-VXI[board]::<logical address>::INSTR
ASRL<port>::INSTR
<LogicalName>
[VInstr->]<VirtualInstrument>

If you do not specify a value for an optional field, the following values are used:

Optional Field - Value
------------------------------------------------------
board - 0
secondary address - none (31)

The following table contains example valid values for this parameter.

"Valid Value" - Description
------------------------------------------------------
"GPIB::22::INSTR" - GPIB board 0, primary address 22 no
                    secondary address
"GPIB::22::5::INSTR" - GPIB board 0, primary address 22
                       secondary address 5
"GPIB1::22::5::INSTR" - GPIB board 1, primary address 22
                        secondary address 5
"VXI::64::INSTR" - VXI board 0, logical address 64
"VXI1::64::INSTR" - VXI board 1, logical address 64
"GPIB-VXI::64::INSTR" - GPIB-VXI board 0, logical address 64
"GPIB-VXI1::64::INSTR" - GPIB-VXI board 1, logical address 64
"ASRL2::INSTR" - COM port 2
"SampleInstr" - Logical name "SampleInstr"
"VInstr->xyz432" - Virtual Instrument "xyz432"
"xyz432" - Logical Name or Virtual Instrument "xyz432"

/*=CHANGE:===================================================* 

Modify the following default value so that it reflects the default address for your instrument.  You must make the corresponding change to the Default Value entry for the control.

 *================================================END=CHANGE=*/ 
Default Value:  "GPIB::14::INSTR"

Note: You specify the resource name with the "VInstr->" if you have the logical name that is the same as the virtual instrument name and you want to explicitly use the virtual instrument name. Otherwise, the driver uses the logical name.        Specify whether you want the instrument driver to perform an ID Query.

Valid Range:
VI_TRUE  (1) - Perform ID Query (Default Value)
VI_FALSE (0) - Skip ID Query

When you set this parameter to VI_TRUE, the driver verifies that the instrument you initialize is a type that this driver supports.  

Circumstances can arise where it is undesirable to send an ID Query command string to the instrument.  When you set this parameter to VI_FALSE, the function initializes the instrument without performing an ID Query.         Specify whether you want the to reset the instrument during the initialization procedure.

Valid Range:
VI_TRUE  (1) - Reset Device (Default Value)
VI_FALSE (0) - Don't Reset

        Returns a ViSession handle that you use to identify the instrument in all subsequent instrument driver function calls.

Notes:

(1) This function creates a new session each time you invoke it.  This is useful if you have multiple physical instances of the same type of instrument.  

(2) Avoid creating multiple concurrent sessions to the same physical instrument.  Although you can create more than one IVI session for the same resource, it is best not to do so.  A better approach is to use the same IVI session in multiple execution threads.  You can use functions AUMT8820_LockSession and AUMT8820_UnlockSession to protect sections of code that require exclusive access to the resource.

        Reports the status of this operation.

To obtain a text description of the status code, or if the status code is not listed below, call the AUMT8820_error_message function.  To obtain additional information about the error condition, use the AUMT8820_GetErrorInfo and AUMT8820_ClearErrorInfo functions.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported.
3FFC0102  Reset not supported.

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFA0000  Cannot load IVI engine.
BFFA0001  Instrument error. Call AUMT8820_error_query.
BFFA000C  Invalid attribute.
BFFA000D  Attribute is not writable.
BFFA000E  Attribute is not readable.
BFFA000F  Invalid parameter.
BFFA0010  Invalid value.
BFFA0012  Attribute not supported.
BFFA0013  Value not supported.
BFFA0014  Invalid type.
BFFA0015  Types do not match.
BFFA0016  Attribute already has a value waiting to be updated.
BFFA0018  Not a valid configuration.
BFFA0019  Requested item does not exist or value not available.
BFFA001A  Requested attribute value not known.
BFFA001B  No range table.
BFFA001C  Range table is invalid.
BFFA001F  No channel table has been built for the session.
BFFA0020  Channel name specified is not valid.
BFFA0044  Channel name required.
BFFA0045  Channel name not allowed.
BFFA0046  Attribute not valid for channel.
BFFA0047  Attribute must be channel based.
BFFA0054  Bad channel name in Channel List.

BFFC0011  Instrument returned invalid response to ID Query.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  A "no listeners" condition was detected.
BFFF0060  This interface is not the controller-in-charge.
BFFF0067  Operation is not supported on this session.
    T =         Resource Name                      s         ID Query                                    Reset Device                      k L`       instrSession                      ) c      status                            z                                            "GPIB0::1::INSTR"   Yes VI_TRUE No VI_FALSE   Yes VI_TRUE No VI_FALSE    	           	           FCopyright 1998 National Instruments Corporation. All Rights Reserved.       This function performs the following operations:

- Closes the instrument I/O session.

- Destroys the instrument driver session and all of its attributes.

- Deallocates any memory resources the driver uses.

Notes:

(1) You must unlock the session before calling AUMT8820_close.

(2) After calling AUMT8820_close, you cannot use the instrument driver again until you call AUMT8820_init or AUMT8820_InitWithOptions.

        Reports the status of this operation.

To obtain a text description of the status code, or if the status code is not listed below, call the AUMT8820_error_message function.  To obtain additional information about the error condition, use the AUMT8820_GetErrorInfo and AUMT8820_ClearErrorInfo functions.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  A "no listeners" condition was detected.
BFFF0060  This interface is not the controller-in-charge.
BFFF0067  Operation is not supported on this session.
         The ViSession handle that you obtain from the AUMT8820_init or AUMT8820_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
    ! 6      status                            & 2         instrSession                       	                  *CLS

Clear Status Command
Clearing status

Function: Clears the standard event status register and the status byte register (except the output queue and MAV bits).
Command:  *CLS
Query:    None
Response: None

Description:
Sending *CLS command after a program message terminator or before a query mes-sage unit causes all status byte registers to be cleared.


Sample programming
To clear the standard event status register and the status byte register (except the out-put queue and MAV bits):
*CLS
 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
    )G $     `    instrSession                      )t $  `    status                             0    	               *ESE

Standard Event Status Enable Command
Setting standard event status enable register

Function: Sets the standard event status enable register.  When the set event occurs, the end summary bit (ESB, bit 5) of the status byte register becomes "1" (true).
Command:  *ESE register
Query:    *ESE?
Response: register

Parameters:
          register    Standard event status enable register
                      Value = bit 0 + bit 1 + ... + bit 7

bit0 = 20 = 1   : Operation complete
bit1 = 21 = 2   : Request control
bit2 = 22 = 4   : Query error
bit3 = 23 = 8   : Device error
bit4 = 24 = 16  : Execution error
bit5 = 25 = 32  : Command error
bit6 = 26 = 64  : User request
bit7 = 27 = 128 : Power On

Description:
From among the values 
20 = 1, 
21 = 2, 
22 = 4, 
23 = 8, 
24 = 16, 
25 = 32, 
26 = 64,
27 = 128, which correspond to bits 1, 2, 3, 4, 5, 6 and 7 of the standard event status en-able register; the sum of values of bits to be enabled becomes the parameter.


Sample programming
To enable the execution error event:
*ESE 16
 
     %    ViSession handle to the instrument
        mask is an int with these defined values

AUMT8820_ESE_MASK_B0_OPERATION_COMPLETE 1
AUMT8820_ESE_MASK_B1_REQUEST_CONTROL    2
AUMT8820_ESE_MASK_B2_QUERY_ERROR        4
AUMT8820_ESE_MASK_B3_DEVICE_ERROR       8
AUMT8820_ESE_MASK_B4_EXECUTION_ERROR    16
AUMT8820_ESE_MASK_B5_COMMAND_ERROR      32
AUMT8820_ESE_MASK_B6_USER_REQUEST       64
AUMT8820_ESE_MASK_B7_POWER_ON           128
     ?    Reports the status of this operation.
  for details see Init
    .R $     `    instSession                       . d        mask                              0 %  `    status                             0                          	               *ESE

Standard Event Status Enable Command
Setting standard event status enable register

Function: Sets the standard event status enable register.  When the set event occurs, the end summary bit (ESB, bit 5) of the status byte register becomes "1" (true).
Command:  *ESE register
Query:    *ESE?
Response: register

Parameters:
          register    Standard event status enable register
                      Value = bit 0 + bit 1 + ... + bit 7

bit0 = 20 = 1   : Operation complete
bit1 = 21 = 2   : Request control
bit2 = 22 = 4   : Query error
bit3 = 23 = 8   : Device error
bit4 = 24 = 16  : Execution error
bit5 = 25 = 32  : Command error
bit6 = 26 = 64  : User request
bit7 = 27 = 128 : Power On

Description:
From among the values 
20 = 1, 
21 = 2, 
22 = 4, 
23 = 8, 
24 = 16, 
25 = 32, 
26 = 64,
27 = 128, which correspond to bits 1, 2, 3, 4, 5, 6 and 7 of the standard event status en-able register; the sum of values of bits to be enabled becomes the parameter.


Sample programming
To enable the execution error event:
*ESE 16
 
     %    ViSession handle to the instrument
        mask returns an int with these defined values

AUMT8820_ESE_MASK_B0_OPERATION_COMPLETE 1
AUMT8820_ESE_MASK_B1_REQUEST_CONTROL    2
AUMT8820_ESE_MASK_B2_QUERY_ERROR        4
AUMT8820_ESE_MASK_B3_DEVICE_ERROR       8
AUMT8820_ESE_MASK_B4_EXECUTION_ERROR    16
AUMT8820_ESE_MASK_B5_COMMAND_ERROR      32
AUMT8820_ESE_MASK_B6_USER_REQUEST       64
AUMT8820_ESE_MASK_B7_POWER_ON           128
     ?    Reports the status of this operation.
  for details see Init
    52 $     `    instrSession                      5_ {   `    mask                              6 %  `    status                             0    	            	               *ESR?

Standard Event Status Register Query
Querying the standard event status register

Function: Queries the standard event status register.  The event that occurred can be identified depending on the read value.
Command:  None
Query:    *ESR?
Response: register

Parameters:
          register    Standard event status register
                      Value = bit0 + bit1 + ... + bit7
bit0 = 20 = 1   : Operation complete
bit1 = 21 = 2   : Request control
bit2 = 22 = 4   : Query error
bit3 = 23 = 8   : Device error
bit4 = 24 = 16  : Execution error
bit5 = 25 = 32  : Command error
bit6 = 26 = 64  : User request
bit7 = 27 = 128 : Power On

Description:
The sum of the values 
20 = 1, 
21 = 2, 
22 = 4, 
23 = 8, 
24 = 16, 
25 = 32, 
26 = 64, 
27 = 128 becomes the parameter, which correspond to bits 1, 2, 3, 4, 5, 6 and 7 of the standard event status register.  When the response is read, the standard event status register is cleared.


Sample programming
To read the standard event status register:
*ESR?
 
     %    ViSession handle to the instrument
        The standard status register contents
valu returns an int with these defined values

AUMT8820_ESE_MASK_B0_OPERATION_COMPLETE 1
AUMT8820_ESE_MASK_B1_REQUEST_CONTROL    2
AUMT8820_ESE_MASK_B2_QUERY_ERROR        4
AUMT8820_ESE_MASK_B3_DEVICE_ERROR       8
AUMT8820_ESE_MASK_B4_EXECUTION_ERROR    16
AUMT8820_ESE_MASK_B5_COMMAND_ERROR      32
AUMT8820_ESE_MASK_B6_USER_REQUEST       64
AUMT8820_ESE_MASK_B7_POWER_ON           128
     ?    Reports the status of this operation.
  for details see Init
    ; $     `    instrSession                      < x   `    value                             = %  `    status                             0    	            	               *IDN?

Identification Query
Querying identification information

Function: Inquires the identification information of the device on the GPIB bus.
Command:  None
Query:    *IDN?
Response: ANRITSU,MT8820A,0,firm

Parameters:

ANRITSU : Company name (Anritsu Corporation)
MT8820A : Model name of device
firm    : Firmware revision


Sample programming
To query the identification information of MT8820A:
*IDN?
     %    ViSession handle to the instrument
         Response from instrument:
ANRITSU,MT8820A,0,firmware version


note: ViChr[] initial setting of a Function Panel

      Declare Variable
            1.Variable Name      :Arbitrary name
            2.Number of Elements :Arbitrary number     ?    Reports the status of this operation.
  for details see Init
    @s $     `    instrSession                      @ u        string                            A )  `    status                             _tmp1    -        "ANRITSU,MT8820A,0,firmware version"    	           1    *OPC

Operation Complete
Operation complete

Function: When all of the selected pending device operations have been completed, the *OPC command sets bit 0 (operation complete) of the standard event status register.
When all of the selected pending operations have been completed, the *OPC? com-mand sets "1" in the output queue and waits until MAV occurs.
Command:  *OPC
Query:    *OPC?
Response: operation

Parameters:
          operation   Operation complete flag

          1   : Operation complete

Sample programming
To query operation completion:
*OPC?
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
    D $     `    instrSession                      E' !  `    status                             0    	           1    *OPC

Operation Complete
Operation complete

Function: When all of the selected pending device operations have been completed, the *OPC command sets bit 0 (operation complete) of the standard event status register.
When all of the selected pending operations have been completed, the *OPC? com-mand sets "1" in the output queue and waits until MAV occurs.
Command:  *OPC
Query:    *OPC?
Response: operation

Parameters:
          operation   Operation complete flag

          1   : Operation complete

Sample programming
To query operation completion:
*OPC?
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         mode returns an int with these defined values

AUMT8820_OPERATION_COMPLETE_COMPLETED      1
AUMT8820_OPERATION_COMPLETE_EXECUTING      0
    H" $     `    instrSession                      HO $  `    status                            H m   `    mode                               0    	            	           c    *RST

Reset
Initialization (level: Instrument Initial)

Function: Performs initialization at the Instrument Initial level.
Command:  *RST
Query:    None
Response: None

Description:
Initializes all parameters of the loaded measurement software to the status at factory shipment (except the Full Calibration and Band Calibration data).  The parameters for common function is not initialized.


Sample programming
To initialize at the Instrument Initial level:
*RST
Related commands
RESET INST  : Same function as *RST.
RESET FACTORY   : Initializing at the Factory Initial level.
RESET SYSTEM    : Initializing at the System Initial level.
PRE : Initializing at the System Initial level.
IP  : Initializing at the System Initial level.
RESET POWERON   : Initializing at the Power On Initial level.
INI : Initializing parameters for the loaded measurement soft-ware.
     L    ViSession handle to the instrument

Reset the instrument to default values     ?    Reports the status of this operation.
  for details see Init
    MP $     `    instrSession                      M #  `    status                             0    	               *SRE

Service Request Enable Command
Setting service request enable register

Function: Sets the service request enable register.  When the event set in the service request enable register occurs, the MSS bit (bit 6) of the status byte register becomes "1" (true).
Command:  *SRE register
Query:    *SRE?
Response: register

Parameters:
          register    Service request enable register
                      Value = bit 0 + bit 1 + ... + bit 7

bit 0 = 20 = 1   : Not used
bit 1 = 21 = 2   : Not used
bit 2 = 22 = 4   : ERR event status register
bit 3 = 23 = 8   : END event status register
bit 4 = 24 = 16  : MAV
bit 5 = 25 = 32  : ESB
bit 6 = 26 = 64  : MSS or RQS
bit 7 = 27 = 128 : Not used

Description:
From among the values 20 = 1, 21 = 2, 22 = 4, 23 = 8, 24 = 16, 25 = 32, 26 = 64, and 27 = 128, which correspond to bits 1, 2, 3, 4, 5, 6 and 7 of the service request enable register; the sum of values of bits desired to be enabled becomes the parameter.


Sample programming
To set MSS bit to "1" (true) when an end event occurs:
*SRE 8
     %    ViSession handle to the instrument
    4    Register mask value

AUMT8820_STB_MASK_B0_NOT_USED    1
AUMT8820_STB_MASK_B1_NOT_USED    2
AUMT8820_STB_MASK_B2_ERR_EVENT   4
AUMT8820_STB_MASK_B3_END_EVENT   8
AUMT8820_STB_MASK_B4_MAV         16
AUMT8820_STB_MASK_B5_ESB         32
AUMT8820_STB_MASK_B6_MSS_OR_RQS  64
AUMT8820_STB_MASK_B7_NOT_USED    128
     ?    Reports the status of this operation.
  for details see Init
    R $     `    instrSession                      R m   `    mask                              S '  `    status                             0       <                   	               *SRE

Service Request Enable Command
Setting service request enable register

Function: Sets the service request enable register.  When the event set in the service request enable register occurs, the MSS bit (bit 6) of the status byte register becomes "1" (true).
Command:  *SRE register
Query:    *SRE?
Response: register

Parameters:
          register    Service request enable register
                      Value = bit 0 + bit 1 + ... + bit 7

bit 0 = 20 = 1   : Not used
bit 1 = 21 = 2   : Not used
bit 2 = 22 = 4   : ERR event status register
bit 3 = 23 = 8   : END event status register
bit 4 = 24 = 16  : MAV
bit 5 = 25 = 32  : ESB
bit 6 = 26 = 64  : MSS or RQS
bit 7 = 27 = 128 : Not used

Description:
From among the values 20 = 1, 21 = 2, 22 = 4, 23 = 8, 24 = 16, 25 = 32, 26 = 64, and 27 = 128, which correspond to bits 1, 2, 3, 4, 5, 6 and 7 of the service request enable register; the sum of values of bits desired to be enabled becomes the parameter.


Sample programming
To set MSS bit to "1" (true) when an end event occurs:
*SRE 8
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
    4    Register mask value

AUMT8820_STB_MASK_B0_NOT_USED    1
AUMT8820_STB_MASK_B1_NOT_USED    2
AUMT8820_STB_MASK_B2_ERR_EVENT   4
AUMT8820_STB_MASK_B3_END_EVENT   8
AUMT8820_STB_MASK_B4_MAV         16
AUMT8820_STB_MASK_B5_ESB         32
AUMT8820_STB_MASK_B6_MSS_OR_RQS  64
AUMT8820_STB_MASK_B7_NOT_USED    128
    Y' $     `    instrSession                      YT #  `    status                            Y q   `    mask                               0    	            	               *STB?

Status Byte Register
Querying the status byte register

Function: Queries the status byte register value.  Bit 6 of the status byte register is read out as MSS (master summary status).
Command:  None
Query:    *STB?
Response: register

Parameters:
          register    Status byte register
                      Value = bit 0 + bit 1 + ... + bit 7

bit 0 = 20 = 1    : Not used
bit 1 = 21 = 2    : Not used
bit 2 = 22 = 4    : ERR event status register
bit 3 = 23 = 8    : END event status register
bit 4 = 24 = 16   : MAV
bit 5 = 25 = 32   : ESB
bit 6 = 26 = 64   : MSS
bit 7 = 27 = 128  : Not used

Sample programming
To read the status byte register value:
*STB?
 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
    4    Register mask value

AUMT8820_STB_MASK_B0_NOT_USED    1
AUMT8820_STB_MASK_B1_NOT_USED    2
AUMT8820_STB_MASK_B2_ERR_EVENT   4
AUMT8820_STB_MASK_B3_END_EVENT   8
AUMT8820_STB_MASK_B4_MAV         16
AUMT8820_STB_MASK_B5_ESB         32
AUMT8820_STB_MASK_B6_MSS_OR_RQS  64
AUMT8820_STB_MASK_B7_NOT_USED    128
    ^A $     `    instrSession                      ^n "  `    status                            ^ m   `    value                              0    	            	            i    *TRG

Trigger
Trigger a measurement sweep

Function: None
Command:  *TRG
Query:    None
Response: None
     ;    ViSession handle to the instrument

Trigger a measurement    a 0     `    instrSession                     +  `    status                             0    	               *TST?

Self Test
Self-diagnosis

Function: Queries the self-diagnosis result.
Command:  None
Query:    *TST?
Response: test_result

Parameters:
          test_result

          0   : Normal end


Sample programming
To query the self-diagnosis result:
*TST?
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         Query the self test result
test_result returns an int with these defined values

AUMT8820_TEST_RESULT_NORMAL_END      0
AUMT8820_TEST_RESULT_ERROR           1
    b $     `    instrSession                      c "  `    status                            c[ u   `    test_result                        0    	            	               *WAI

Wait to Continue
Waiting for command execution

Function: During command execution, puts the next command in waiting status.
Command:  *WAI
Query:    None
Response: None

Description:
The *WAI command executes overlapped commands as sequential commands.  This command is meaningless because MT8820A does not support overlapped commands.


Sample programming
To put the next command in waiting status:
*WAI
 
     C    ViSession handle to the instrument

Wait for command to complete
     ?    Reports the status of this operation.
  for details see Init
    fh $     `    instrSession                      f "  `    status                             0    	           9    ALARM

Beep Sound
Setting beep sound

Function: Sets whether or not to sound the beep when an error occurs or for other condition.
Command:  ALARM on_off
Query:    ALARM?
Response: on_off

Parameters:
          on_off  Sets the beep sound.

          ON  : Sounds the beep.
          OFF : Does not sound the beep.
          1   : Sounds the beep.
          0   : Does not sound the beep.

          Initial value = ON


Sample programming
To set not to sound the beep:
ALARM OFF



Related commands
BEP : Same function as ALARM.  However, BEP has no query function.
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
     u    sound is an int with these defined values

AUMT8820_ALARM_SOUND_MODE_ON      1
AUMT8820_ALARM_SOUND_MODE_OFF     0
    i $     `    instrSession                      i #  `    status                            j* s Q       sound                              0    	                       ON 1 OFF 0   9    ALARM

Beep Sound
Setting beep sound

Function: Sets whether or not to sound the beep when an error occurs or for other condition.
Command:  ALARM on_off
Query:    ALARM?
Response: on_off

Parameters:
          on_off  Sets the beep sound.

          ON  : Sounds the beep.
          OFF : Does not sound the beep.
          1   : Sounds the beep.
          0   : Does not sound the beep.

          Initial value = ON


Sample programming
To set not to sound the beep:
ALARM OFF



Related commands
BEP : Same function as ALARM.  However, BEP has no query function.
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
     z    sound returns an int with these defined values

AUMT8820_ALARM_SOUND_MODE_ON      1
AUMT8820_ALARM_SOUND_MODE_OFF     0
    m $     `    instrSession                      m '  `    status                            n& {   `    sound                              0    	            	           9    ALARM

Beep Sound
Setting beep sound

Function: Sets whether or not to sound the beep when an error occurs or for other condition.
Command:  ALARM on_off
Query:    ALARM?
Response: on_off

Parameters:
          on_off  Sets the beep sound.

          ON  : Sounds the beep.
          OFF : Does not sound the beep.
          1   : Sounds the beep.
          0   : Does not sound the beep.

          Initial value = ON


Sample programming
To set not to sound the beep:
ALARM OFF



Related commands
BEP : Same function as ALARM.  However, BEP has no query function.
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
     u    sound is an int with these defined values

AUMT8820_ALARM_SOUND_MODE_ON      1
AUMT8820_ALARM_SOUND_MODE_OFF     0
    q $     `    instrSession                      q #  `    status                            r n S      sound                              0    	                       ON 1 OFF 0        BZR

Sound Buzzer
Sounding the buzzer

Function: Sounds the buzzer.
Command:  BZR
Query:    None
Response: None

Description:
This function is available only for remote control.


Sample programming
To sound the buzzer:
BZR
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
    tJ $     `    instrSession                      tw (  `    status                             0    	               CONTS

Continuous Mode Measure
Starting measurement in the continuous mode

Function: Starts measurement in the continuous mode.  That is, performs another measurement when one has completed.
Command:  CONTS
Query:    None
Response: None

Parameters:
          None

Description:
When MT8820A receives the next command during measurement started with the CONTS command, the measurement stops and processing for that command starts.


Sample programming
To start measurement in the continuous mode:
CONTS



Related commands
S1  Same function as CONTS.

Starts continuous sweep mode, but any further commands stop sweep if not completed, use SWP to synchronize a sweep     N    ViSession handle to the instrument

Start measurement in the continuous mode     ?    Reports the status of this operation.
  for details see Init
    w $     `    instrSession                      x4 "  `    status                             0    	               DATE

Date
Setting the date

Function: Sets the date.  Query inquires the current date.
Command:  DATE year,month,day
Query:    DATE?
Response: year,month,day

Parameters:
          year    Year
                  Range = 2001 to 2030

          month   Month
                  Range = 1 to 12

          day Day
              Range = 1 to 31


Sample programming
To set the date to July 23, 2001:
DATE 2001,07,23
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         year (2001-2030)         month (1-12)         day (1-31)    z $     `    instrSession                      z %  `    status                            { g        year                              {+         month                             {A         day                                0    	                                                                        DATE

Date
Setting the date

Function: Sets the date.  Query inquires the current date.
Command:  DATE year,month,day
Query:    DATE?
Response: year,month,day

Parameters:
          year    Year
                  Range = 2001 to 2030

          month   Month
                  Range = 1 to 12

          day     Day
                  Range = 1 to 31


Sample programming
To set the date to July 23, 2001:
DATE 2001,07,23
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         year (2001-2030)         month (1-12)         day (1-31)    ~c $     `    instrSession                      ~ $  `    status                            ~ q   `    year                              ~    `    month                                 `    day                                0    	            	            	            	               DATEMODE

Date Format
Date format

Function: Sets the display format for the date.
Command:  DATEMODE format
Query:    DATEMODE?
Response: format

Parameters:
          format  Display format for the date

          YMD : yyyy/mm/dd
          MDY : mm/dd/yyyy
          DMY : dd/mm/yyyy

          Initial value = YMD
          Where, yyyy: year, mm: month, dd: day.


Sample programming
To display the date in dd/mm/yyyy format:
DATEMODE DMY
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         mode is an int with these defined values

AUMT8820_DATE_MODE_YYYY_MM_DD      0
AUMT8820_DATE_MODE_MM_DD_YYYY      1
AUMT8820_DATE_MODE_DD_MM_YYYY      2
     $     `    instrSession                      K %  `    status                             n v       mode                               0    	                       3year/month/day 0 month/day/year 1 day/month/year 2       DATEMODE

Date Format
Date format

Function: Sets the display format for the date.
Command:  DATEMODE format
Query:    DATEMODE?
Response: format

Parameters:
          format  Display format for the date

          YMD : yyyy/mm/dd
          MDY : mm/dd/yyyy
          DMY : dd/mm/yyyy

          Initial value = YMD
          Where, yyyy: year, mm: month, dd: day.


Sample programming
To display the date in dd/mm/yyyy format:
DATEMODE DMY
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         mode returns an int with these defined values

AUMT8820_DATE_MODE_YYYY_MM_DD      0
AUMT8820_DATE_MODE_MM_DD_YYYY      1
AUMT8820_DATE_MODE_DD_MM_YYYY      2
     $     `    instrSession                       *  `    status                            `    `    mode                               0    	            	           I    DISPL

Panel Display Power
Power switch of the LCD panel 

Function: Sets the power switch on the LCD panel to On/Off.  Under full remote control, set-ting the LCD panel power to Off enables power-saving operation.
Command:  DISPL on_off
Query:    DISPL?
Response: on_off

Parameters:
          on_off  LCD panel power

          ON  : LCD panel power On (normal display)
          OFF : LCD panel power Off

          Initial value = ON

Description:
This function is available only for remote control.


Sample programming
To set the liquid crystal panel power to Off:
DISPL OFF
 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
     x    mode is an int with these defined values

AUMT8820_PANEL_DISPLAY_MODE_ON      0
AUMT8820_PANEL_DISPLAY_MODE_OFF     1
     $     `    instrSession                      B )  `    status                             l V       mode                               0    	                       ON 0 OFF 1   I    DISPL

Panel Display Power
Power switch of the LCD panel 

Function: Sets the power switch on the LCD panel to On/Off.  Under full remote control, set-ting the LCD panel power to Off enables power-saving operation.
Command:  DISPL on_off
Query:    DISPL?
Response: on_off

Parameters:
          on_off  LCD panel power

          ON  : LCD panel power On (normal display)
          OFF : LCD panel power Off

          Initial value = ON

Description:
This function is available only for remote control.


Sample programming
To set the liquid crystal panel power to Off:
DISPL OFF
 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
     }    mode returns an int with these defined values

AUMT8820_PANEL_DISPLAY_MODE_ON      0
AUMT8820_PANEL_DISPLAY_MODE_OFF     1
    $ $     `    instrSession                      Q (  `    status                             r   `    mode                               0    	            	           m    ESE2

END Event Status Enable Register
Setting end event status enable register

Function: Sets the end event status enable register.  When the set end-event occurs, the end summary bit (ESB, bit 2) of the status byte register becomes "1" (true).
Command:  ESE2 register
Query:    ESE2?
Response: register

Parameters:
          register    End event status enable register
                      Value = bit 0 + bit 1 + ... + bit 7

          when using W-CDMA or GSM measurement software
          bit 0 = 20 = 1    : Measurement/sweep complete
          bit 1 = 21 = 2    : Not used
          bit 2 = 22 = 4    : Reception measurement complete
          bit 3 = 23 = 8    : Transmission measurement complete
          bit 4 = 24 = 16   : Audio measurement complete
          bit 5 = 25 = 32   : Not used
          bit 6 = 26 = 64   : Not used
          bit 7 = 27 = 128  : Not used

          when using CDMA2000 measurement software
          bit 0 = 20 = 1    : All measurement complete
          bit 1 = 21 = 2    : Access Probe Power measurement complete
          bit 2 = 22 = 4    : Reception measurement complete
          bit 3 = 23 = 8    : Transmission measurement complete (excepting Access Probe Power)
          bit 4 = 24 = 16   : Not used
          bit 5 = 25 = 32   : Not used
          bit 6 = 26 = 64   : Not used
          bit 7 = 27 = 128  : Not used

          when using PDC measurement software
          bit 0 = 20 = 1    : Measurement/sweep complete
          bit 1 = 21 = 2    : Not used
          bit 2 = 22 = 4    : Reception measurement complete
          bit 3 = 23 = 8    : Transmission measurement complete
          bit 4 = 24 = 16   : Not used
          bit 5 = 25 = 32   : Not used
          bit 6 = 26 = 64   : Not used
          bit 7 = 27 = 128  : Not used

Description:
From among the values 
20 = 1, 
21 = 2, 
22 = 4, 
23 = 8, 
24 = 16, 
25 = 32, 
26 = 64, 
27 = 128, which correspond to bits 1, 2, 3, 4, 5, 6 and 7 of the end event status enable register; the sum of values of bits desired to be enabled becomes the parameter.


Sample programming
To enable the measurement/sweep end event:
ESE2 1  /* 20 = 1 */
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
        Set the END event status register enable mask

mask is an int with these defined values

AUMT8820_ESE2_MASK_B0_             1
AUMT8820_ESE2_MASK_B1_             2
AUMT8820_ESE2_MASK_B2_             4
AUMT8820_ESE2_MASK_B3_             8
AUMT8820_ESE2_MASK_B4_            16
AUMT8820_ESE2_MASK_B5_            32
AUMT8820_ESE2_MASK_B6_            64
AUMT8820_ESE2_MASK_B7_           128
    N $     `    instrSession                      { '  `    status                             w        SEregister                         0    	                                 m    ESE2

END Event Status Enable Register
Setting end event status enable register

Function: Sets the end event status enable register.  When the set end-event occurs, the end summary bit (ESB, bit 2) of the status byte register becomes "1" (true).
Command:  ESE2 register
Query:    ESE2?
Response: register

Parameters:
          register    End event status enable register
                      Value = bit 0 + bit 1 + ... + bit 7

          when using W-CDMA or GSM measurement software
          bit 0 = 20 = 1    : Measurement/sweep complete
          bit 1 = 21 = 2    : Not used
          bit 2 = 22 = 4    : Reception measurement complete
          bit 3 = 23 = 8    : Transmission measurement complete
          bit 4 = 24 = 16   : Audio measurement complete
          bit 5 = 25 = 32   : Not used
          bit 6 = 26 = 64   : Not used
          bit 7 = 27 = 128  : Not used

          when using CDMA2000 measurement software
          bit 0 = 20 = 1    : All measurement complete
          bit 1 = 21 = 2    : Access Probe Power measurement complete
          bit 2 = 22 = 4    : Reception measurement complete
          bit 3 = 23 = 8    : Transmission measurement complete (excepting Access Probe Power)
          bit 4 = 24 = 16   : Not used
          bit 5 = 25 = 32   : Not used
          bit 6 = 26 = 64   : Not used
          bit 7 = 27 = 128  : Not used

          when using PDC measurement software
          bit 0 = 20 = 1    : Measurement/sweep complete
          bit 1 = 21 = 2    : Not used
          bit 2 = 22 = 4    : Reception measurement complete
          bit 3 = 23 = 8    : Transmission measurement complete
          bit 4 = 24 = 16   : Not used
          bit 5 = 25 = 32   : Not used
          bit 6 = 26 = 64   : Not used
          bit 7 = 27 = 128  : Not used

Description:
From among the values 
20 = 1, 
21 = 2, 
22 = 4, 
23 = 8, 
24 = 16, 
25 = 32, 
26 = 64, 
27 = 128, which correspond to bits 1, 2, 3, 4, 5, 6 and 7 of the end event status enable register; the sum of values of bits desired to be enabled becomes the parameter.


Sample programming
To enable the measurement/sweep end event:
ESE2 1  /* 20 = 1 */
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
        Get the END event status register enable mask

mask returns an int with these defined values

AUMT8820_ESE2_MASK_B0_                      1
AUMT8820_ESE2_MASK_B1_                      2
AUMT8820_ESE2_MASK_B2_RX_MEASUREMENT_ERROR  4
AUMT8820_ESE2_MASK_B3_TX_MEASUREMENT_ERROR  8
AUMT8820_ESE2_MASK_B4_                      16
AUMT8820_ESE2_MASK_B5_NOT_USED              32
AUMT8820_ESE2_MASK_B6_NOT_USED              64
AUMT8820_ESE2_MASK_B7_NOT_USED              128
     $     `    instrSession                       $  `    status                             w   `    SEregister                         0    	            	           b    ESE3

ERR Event Status Enable Register
Setting error event status enable register

Function: Sets the error event status enable register.  When the set error-event occurs, the end summary bit (ESB, bit 3) of the status byte register becomes "1" (true).
Command:  ESE3 register
Query:    ESE3?
Response: register

Parameters:
          register    Error event status enable register
                      Value = bit 0 + bit 1 + ... + bit 7
bit 0 = 20 = 1  : Synchronization loss (bit error rate measurement)

          when using W-CDMA or GSM or PDC measurement software
          bit 0 = 20 = 1    : Synchronization loss (bit error rate measurement)
          bit 1 = 21 = 2    : Not used
          bit 2 = 22 = 4    : Transmission measurement complete
          bit 3 = 23 = 8    : Reception measurement complete
          bit 4 = 24 = 16   : Call processing error
          bit 5 = 25 = 32   : Not used
          bit 6 = 26 = 64   : Call drop error
          bit 7 = 27 = 128  : Not used

          when using CDMA2000 measurement software
          bit 0 = 20 = 1    : Not used
          bit 1 = 21 = 2    : Access Probe Power measurement error
          bit 2 = 22 = 4    : Transmission measurement complete
          bit 3 = 23 = 8    : Reception measurement complete
          bit 4 = 24 = 16   : Call processing error
          bit 5 = 25 = 32   : Not used
          bit 6 = 26 = 64   : Call drop error
          bit 7 = 27 = 128  : Not used


Description:
From among the values 
20 = 1, 
21 = 2, 
22 = 4, 
23 = 8, 
24 = 16, 
25 = 32, 
26 = 64, 
27 = 128, which correspond to bits 1, 2, 3, 4, 5, 6 and 7 of the error event status enable register; the sum of values of bits desired to be enabled becomes the parameter.


Sample programming
To enable transmission measurement error and reception error events:
ESE3 12 /* Transmission error (22 = 4) + reception error (23 = 8) */
 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
        Set the Error event status enable register mask

mask is an int with these defined values

AUMT8820_ESE3_MASK_B0_                      1
AUMT8820_ESE3_MASK_B1_                      2
AUMT8820_ESE3_MASK_B2_TX_MEASUREMENT_ERROR  4
AUMT8820_ESE3_MASK_B3_RX_MEASUREMENT_ERROR  8
AUMT8820_ESE3_MASK_B4_CALL_PROCESSING_ERROR 16
AUMT8820_ESE3_MASK_B5_NOT_USED              32
AUMT8820_ESE3_MASK_B6_CALL_DROP_ERROR       64
AUMT8820_ESE3_MASK_B7_NOT_USED              128
      $     `    instrSession                      - %  `    status                            t r        SEregister                         0    	                                 _    ESE3

ERR Event Status Enable Register
Setting error event status enable register

Function: Sets the error event status enable register.  When the set error-event occurs, the end summary bit (ESB, bit 3) of the status byte register becomes "1" (true).
Command:  ESE3 register
Query:    ESE3?
Response: register

Parameters:
          register    Error event status enable register
                      Value = bit 0 + bit 1 + ... + bit 7
bit 0 = 20 = 1  : Synchronization loss (bit error rate measurement)

          when using W-CDMA or GSM or PDC measurement software
          bit 0 = 20 = 1    : Synchronization loss (bit error rate measurement)
          bit 1 = 21 = 2    : Not used
          bit 2 = 22 = 4    : Transmission measurement complete
          bit 3 = 23 = 8    : Reception measurement complete
          bit 4 = 24 = 16   : Call processing error
          bit 5 = 25 = 32   : Not used
          bit 6 = 26 = 64   : Call drop error
          bit 7 = 27 = 128  : Not used

          when using CDMA2000 measurement software
          bit 0 = 20 = 1    : Not used
          bit 1 = 21 = 2    : Access Probe Power measurement error
          bit 2 = 22 = 4    : Transmission measurement complete
          bit 3 = 23 = 8    : Reception measurement complete
          bit 4 = 24 = 16   : Call processing error
          bit 5 = 25 = 32   : Not used
          bit 6 = 26 = 64   : Call drop error
          bit 7 = 27 = 128  : Not used


Description:
From among the values 
20 = 1, 
21 = 2, 
22 = 4, 
23 = 8, 
24 = 16, 
25 = 32, 
26 = 64, 
27 = 128, which correspond to bits 1, 2, 3, 4, 5, 6 and 7 of the error event status enable register; the sum of values of bits desired to be enabled becomes the parameter.


Sample programming
To enable transmission measurement error and reception error events:
ESE3 12 /* Transmission error (22 = 4) + reception error (23 = 8) */     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
        Get the Error event status enable register mask

mask returns an int with these defined values

AUMT8820_ESE3_MASK_B0_                      1
AUMT8820_ESE3_MASK_B1_                      2
AUMT8820_ESE3_MASK_B2_TX_MEASUREMENT_ERROR  4
AUMT8820_ESE3_MASK_B3_RX_MEASUREMENT_ERROR  8
AUMT8820_ESE3_MASK_B4_CALL_PROCESSING_ERROR 16
AUMT8820_ESE3_MASK_B5_NOT_USED              32
AUMT8820_ESE3_MASK_B6_CALL_DROP_ERROR       64
AUMT8820_ESE3_MASK_B7_NOT_USED              128
    | $     `    instrSession                       &  `    status                                `    SEregister                         0    	            	               ESR2?

END Event Status Register Query
Reading end event status register

Function: Reads the end event status register.  The event that occurred can be identified with the read value. 
Command:  None
Query:    ESR2?
Response: register

Parameters:
          register    End event status register
                      Value = bit 0 + bit 1 + ... + bit 7

          when using W-CDMA or GSM measurement software
          bit 0 = 20 = 1    : Measurement/sweep complete
          bit 1 = 21 = 2    : Not used
          bit 2 = 22 = 4    : Reception measurement complete
          bit 3 = 23 = 8    : Transmission measurement complete
          bit 4 = 24 = 16   : Audio measurement complete
          bit 5 = 25 = 32   : Not used
          bit 6 = 26 = 64   : Not used
          bit 7 = 27 = 128  : Not used

          when using CDMA2000 measurement software
          bit 0 = 20 = 1    : All measurement complete
          bit 1 = 21 = 2    : Access Probe Power measurement complete
          bit 2 = 22 = 4    : Reception measurement complete
          bit 3 = 23 = 8    : Transmission measurement complete (excepting Access Probe Power)
          bit 4 = 24 = 16   : Not used
          bit 5 = 25 = 32   : Not used
          bit 6 = 26 = 64   : Not used
          bit 7 = 27 = 128  : Not used

          when using PDC measurement software
          bit 0 = 20 = 1    : Measurement/sweep complete
          bit 1 = 21 = 2    : Not used
          bit 2 = 22 = 4    : Reception measurement complete
          bit 3 = 23 = 8    : Transmission measurement complete
          bit 4 = 24 = 16   : Not used
          bit 5 = 25 = 32   : Not used
          bit 6 = 26 = 64   : Not used
          bit 7 = 27 = 128  : Not used

Description:
The parameter is the sum of the values 
20 = 1, 
21 = 2, 
22 = 4, 
23 = 8, 
24 = 16, 
25 = 32, 
26 = 64, 
27 = 128, which correspond to bits 1, 2, 3, 4, 5, 6 and 7 of the end event status enable register.  When the response is read, the end event status register is cleared.


Sample programming
To read end event status register:
ESR2?
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
        Query the END event status register value

value returns an int with these defined values

AUMT8820_ESE2_MASK_B0_                      1
AUMT8820_ESE2_MASK_B1_                      2
AUMT8820_ESE2_MASK_B2_RX_MEASUREMENT_ERROR  4
AUMT8820_ESE2_MASK_B3_TX_MEASUREMENT_ERROR  8
AUMT8820_ESE2_MASK_B4_                      16
AUMT8820_ESE2_MASK_B5_NOT_USED              32
AUMT8820_ESE2_MASK_B6_NOT_USED              64
AUMT8820_ESE2_MASK_B7_NOT_USED              128    ì $     `    instrSession                       !  `    status                              w   `    event_Status                       0    	            	               ESR3?

Standard Event Status Register Query
Reading the error event status register

Function: Reads the error event status register.  The event that occurred can be identified with the read value.
Command:  None
Query:    ESR3?
Response: register

Parameters:
          register    Error event status register
                      Value = bit 0 + bit 1 + ... + bit 7

          when using W-CDMA or GSM or PDC measurement software
          bit 0 = 20 = 1    : Synchronization loss (bit error rate measurement)
          bit 1 = 21 = 2    : Not used
          bit 2 = 22 = 4    : Transmission measurement complete
          bit 3 = 23 = 8    : Reception measurement complete
          bit 4 = 24 = 16   : Call processing error
          bit 5 = 25 = 32   : Not used
          bit 6 = 26 = 64   : Call drop error
          bit 7 = 27 = 128  : Not used

          when using CDMA2000 measurement software
          bit 0 = 20 = 1    : Not used
          bit 1 = 21 = 2    : Access Probe Power measurement error
          bit 2 = 22 = 4    : Transmission measurement complete
          bit 3 = 23 = 8    : Reception measurement complete
          bit 4 = 24 = 16   : Call processing error
          bit 5 = 25 = 32   : Not used
          bit 6 = 26 = 64   : Call drop error
          bit 7 = 27 = 128  : Not used

Description:
The parameter is the sum of the values 
20 = 1, 
21 = 2, 
22 = 4, 
23 = 8, 
24 = 16, 
25 = 32, 
26 = 64, 
27 = 128, which correspond to bits 1, 2, 3, 4, 5, 6 and 7 of the error event status enable register.  When the response is read, the error event status register is cleared.


Sample programming
To read the end event status register:
ESR3?
 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
        Query the ERR event status register value

value returns an int with these defined values

AUMT8820_ESE3_MASK_B0_                      1
AUMT8820_ESE3_MASK_B1_                      2
AUMT8820_ESE3_MASK_B2_TX_MEASUREMENT_ERROR  4
AUMT8820_ESE3_MASK_B3_RX_MEASUREMENT_ERROR  8
AUMT8820_ESE3_MASK_B4_CALL_PROCESSING_ERROR 16
AUMT8820_ESE3_MASK_B5_NOT_USED              32
AUMT8820_ESE3_MASK_B6_CALL_DROP_ERROR       64
AUMT8820_ESE3_MASK_B7_NOT_USED              128
    H $     `    instrSession                      u '  `    status                            ͼ    `    event_Status                       0    	            	               FULLCAL_TM?

Queries the time for the last Full Calibration

Command:  None
Query:    FULLCAL_TM?
Response: year,month,day,hour,minute,second

Parameters:
          year    Year
                  Range = 2001 to 2030

          month   Month
                  Range = 1 to 12

          day     Day
                  Range = 1 to 31

          hour    Hour (Range = 0 to 23)

          minute  Minute (Range = 0 to 59)

          second  Second (Range = 0 to 59)
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         year (2001-2030)         month (1-12)         day (1-31)         hours (0-23)         minutes (0-59)         seconds (0-59)    + , &    `    instrSession                      X -  `    status                            ҟ y   `    year                              ҹ    `    month                                 `    day                                }   `    hours                                 `    minutes                              `    seconds                            0    	            	            	            	            	            	            	            |    GTL

Function: Change the remote to local control
Command:  GTL
Query:    None
Response: None

Parameters:
          None
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
    ծ - )    `    instrSession                       +|  `    status                             0    	           X    IP

Reset (System Initial)
Initialization at System Initial level

Function: Executes initialization at the System Initial level.
Command:  IP
Query:    None
Response: None

Description:
Initializes all parameters of the measurement software for the active phones to the status at factory shipment (except the Full Calibration and Band Calibration data).  The parameters for common functions are not initialized.


Sample programming
To initialize at System Initial level:
IP



Related commands
RESET SYSTEM    /* Same function as IP */
INI /* Same function as IP */
PRE /* Same function as IP */
     m    ViSession handle to the instrument

Initialize all instrument set parameters to their system default values     ?    Reports the status of this operation.
  for details see Init
     $     `    instrSession                      r )  `    status                             0    	           X    IP

Reset (System Initial)
Initialization at System Initial level

Function: Executes initialization at the System Initial level.
Command:  IP
Query:    None
Response: None

Description:
Initializes all parameters of the measurement software for the active phones to the status at factory shipment (except the Full Calibration and Band Calibration data).  The parameters for common functions are not initialized.


Sample programming
To initialize at System Initial level:
IP



Related commands
RESET SYSTEM    /* Same function as IP */
INI /* Same function as IP */
PRE /* Same function as IP */
     `    ViSession handle to the instrument

Preset the instrument to its current initialization state
     ?    Reports the status of this operation.
  for details see Init
    ܔ $     `    instrSession                       %  `    status                             0    	               MEASSTOP

Measure Stop
Stopping measurement

Function: Stops the measurement currently being performed.
Command:  MEASSTOP
Query:    None
Response: None

Parameters:
          None

Description:
Measurement started with the SWP command cannot be stopped until measurement is completed, and thus this command is not effective.  To stop the measurement halfway, measurement must have been started with the SNGLS command.


Sample programming
To stop measurement:
SNGLS   /* Starts measurement */
MEASSTOP    /* Stops measurement */

 
     U    ViSession handle to the instrument

Stops the measurement currently being performed     ?    Reports the status of this operation.
  for details see Init
     $     `    instrSession                      : %  `    status                             0    	           X    IP

Reset (System Initial)
Initialization at System Initial level

Function: Executes initialization at the System Initial level.
Command:  IP
Query:    None
Response: None

Description:
Initializes all parameters of the measurement software for the active phones to the status at factory shipment (except the Full Calibration and Band Calibration data).  The parameters for common functions are not initialized.


Sample programming
To initialize at System Initial level:
IP



Related commands
RESET SYSTEM    /* Same function as IP */
INI /* Same function as IP */
PRE /* Same function as IP */
     U    ViSession handle to the instrument

Executes initialization at System Initial Level     ?    Reports the status of this operation.
  for details see Init
    \ $     `    instrSession                       $  `    status                             0    	           .    INILEVEL

Initial Level
Setting the initialization level

Function: Sets the initialization level.
Command:  INILEVEL ini_level
Query:    INILEVEL?
Response: ini_level

Parameters:
          ini_level   Initialization level

          FACTORY : Factory Initial level
          INST    : Instrument Initial level
          SYSTEM  : System Initial level
          POWERON : Power On Initial level


Sample programming
To initialize at the Instrument Initial level:
INILEVEL INST   /* Setting initialization level */
RESET   /* Executing initialization */
 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         
initialization_Level is an int with these defined values

AUMT8820_INITIALIZATION_LEVEL_SYSTEM        0
AUMT8820_INITIALIZATION_LEVEL_INSTRUMENT    1
AUMT8820_INITIALIZATION_LEVEL_FACTORYF      2
AUMT8820_INITIALIZATION_LEVEL_POWER_ON      3
     $     `    instrSession                       '  `    status                            % t Z       initialization_Level               0    	                      +Factory 0 Instrument 1 System 2 Power On 3   s    PRMRECALL

Recall Parameter
Reading settings (file number specified)

Function: Reads the parameter file and reflects the settings at MT8820A.
Command:  PRMRECALL fnumber
Query:    None
Response: None

Parameters:
          fnumber File number

          Range 0 to 999

Description:
This command can only read a file whose saved file name is in the format of "default file name + file number".  The default file name varies depending on the measure-ment software.


Sample programming
To read settings of parameter file number 10:
PRMRECALL 10



Related commands
PRMRECALLNAME   : Reading the file of a specified file name
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         file number

Range 0 to 999
     $     `    instrSession                       %  `    status                             p         file_Number                        0    	                                    PRMRECALLNAME

Recall Parameter
Reading settings (name specified)

Function: Reads the parameter file and reflects the settings at MT8820A.
Command:  PRMRECALLNAME fname
Query:    None
Response: None

Parameters:
          fname   File name


Sample programming
To read settings of parameter file name TEST:
PRMRECALLNAME "TEST"



Related commands
PRMRECALL   : Reading the file of a specified file number
 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         file name to recall     $     `    instrSession                       &  `    status                             j    `    file_Name                          0    	            "TEST"   L    PRMSAVE

Save Parameter
Saving parameter settings (file number specified)

Function: Saves parameter settings as a file.
Command:  PRMSAVE fnumber
Query:    None
Response: None

Parameters:
         fnumber File number (optional)
                 When omitted, the file is saved with the smallest number of those unused.

Description:
The file saved with this command is assigned a name in the format of "default file name + file number."  The default file name varies depending on the measurement software.


Sample programming
To save a file with parameter file number 12:
PRMSAVE 12
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
    * $     `    instrSession                      W &  `    status                             0    	           e    PRMSAVE

Save Parameter
Saving parameter settings (file number specified)

Function: Saves parameter settings as a file.
Command:  PRMSAVE fnumber
Query:    None
Response: None

Parameters:
         fnumber File number (optional)
                 When omitted, the file is saved with the smallest number of those unused.

         Range 0 to 999

Description:
The file saved with this command is assigned a name in the format of "default file name + file number."  The default file name varies depending on the measurement software.


Sample programming
To save a file with parameter file number 12:
PRMSAVE 12
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         file number

Range 0 to 999     $     `    instrSession                       $  `    status                             n        file_Number                        0    	                                ;    PRMSAVENAME

Save Parameter
Saving parameter settings (name specified)

Function: Saves the parameter settings as a file.
Command:  PRMSAVENAME fname
Query:    None
Response: None

Parameters:
          fname   File name


Sample programming
To save the settings with parameter file name TEST:
PRMSAVENAME "TEST"
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         file name to save parameters    ) $     `    instrSession                      V '  `    status                             x    `    file_Name                          0    	            "TEST"   %    REF

Reference Frequency

Function: Sets the reference frequency.
Command:  REF ref_freq
Query:    REF?
Response: ref_freq

Parameters:
          ref_freq    Reference frequency

          10MHZINT    : Internal reference frequency oscillator (10 MHz)
          10MHZEXT    : External input reference frequency (10 MHz)
          13MHZEXT    : External input reference frequency (13 MHz)

          Initial value = 10MHZINT


Sample programming
To set external input reference frequency (13MHz) as the reference frequency to be used:
REF 13MHZEXT
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         Set the reference input frequency

frequency is an int with these defined values

AUMT8820_REFERENCE_FREQUENCY_10_MHZ_INTERNAL      0
AUMT8820_REFERENCE_FREQUENCY_10_MHZ_EXTERNAL      1
AUMT8820_REFERENCE_FREQUENCY_13_MHZ_EXTERNAL      2
     $     `    instrSession                       %  `    status                             q f       frequency                          0    	                       *10MHz (INT) 0 10MHz (EXT) 1 13MHz (EXT) 2   %    REF

Reference Frequency

Function: Sets the reference frequency.
Command:  REF ref_freq
Query:    REF?
Response: ref_freq

Parameters:
          ref_freq    Reference frequency

          10MHZINT    : Internal reference frequency oscillator (10 MHz)
          10MHZEXT    : External input reference frequency (10 MHz)
          13MHZEXT    : External input reference frequency (13 MHz)

          Initial value = 10MHZINT


Sample programming
To set external input reference frequency (13MHz) as the reference frequency to be used:
REF 13MHZEXT
         Get the reference input frequency

frequency returns an int with these defined values

AUMT8820_REFERENCE_FREQUENCY_10_MHZ_INTERNAL      0
AUMT8820_REFERENCE_FREQUENCY_10_MHZ_EXTERNAL      1
AUMT8820_REFERENCE_FREQUENCY_13_MHZ_EXTERNAL      2
   $     `    instrSession                     $  `    status                            ,    `    frequency                          0    	            	           n    RFOUT

RF Output
RF signal output connector

Function: Sets the RF signal output connector.
Command:  RFOUT phone_no,out
Query:    RFOUT? phone_no
Response: out,phone_no

Parameters:
          phone_no    Phone number (omittable)
                      Value = 1
          When omitted for query, phone_no is not contained in the response.

          out RF signal output connector

          MAIN   : Main input/output connector
          AUX    : Auxiliary output connector

          Initial value = MAIN


Sample programming
To set the auxiliary output connector as the output destination for Phone 1:
RFOUT AUX, 1
 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         Set the RF signal output connector

connector returns an int with these defined values

AUMT8820_RF_SIGANL_OUTPUT_CONNECTOR_MAIN_IN_OUT_CONNECTOR     0
AUMT8820_RF_SIGANL_OUTPUT_CONNECTOR_AUX_OUTPUT_CONNECTOR      1
   [ $     `    instrSession                      !  `    status                            ~ O       connector                          0    	                       
Main 0 AUX 1   n    RFOUT

RF Output
RF signal output connector

Function: Sets the RF signal output connector.
Command:  RFOUT phone_no,out
Query:    RFOUT? phone_no
Response: out,phone_no

Parameters:
          phone_no    Phone number (omittable)
                      Value = 1
          When omitted for query, phone_no is not contained in the response.

          out RF signal output connector

          MAIN   : Main input/output connector
          AUX    : Auxiliary output connector

          Initial value = MAIN


Sample programming
To set the auxiliary output connector as the output destination for Phone 1:
RFOUT AUX, 1
 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         Set the RF signal output connector

connector returns an int with these defined values

AUMT8820_RF_SIGANL_OUTPUT_CONNECTOR_MAIN_IN_OUT_CONNECTOR     0
AUMT8820_RF_SIGANL_OUTPUT_CONNECTOR_AUX_OUTPUT_CONNECTOR      1
    $     `    instrSession                     	  &  `    status                           	g    `    connector                          0    	            	           U    RLCD?

Directory Pass
Path to the reading directory

Function: Queries the absolute path to the directory in which the parameter set file to be read is.
Command:  None
Query:    RLCD?
Response: dir_path

Parameters:
          dir_path    Path to the reading directory


Sample programming
To query the path to the reading directory:
RLCD?
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
     R    the absolute path to the directory in which the parameter files will be accessed   b $     `    instrSession                      #  `    status                             L      directory                          0    	                    "Directory Pass"       RLFLIST

File List
File stored in reading directory

Function: When reading the parameter setting file, queries the name and attribute of the file saved in the reading directory.
Command:  None
Query:    RLIST?
Response: num,a1,name1,a2,name2,...,a(num),name(num)

Parameters:
          num Total number of files (including directory)

          a(x)    Attribute of x'th file

          1   : Archive file (including files with no attribute)
          2   : Read-only file

          name(x) Parameter setting file name (maximum 255 characters)


Sample programming
To query a list of parameter setting files in the reading directory:
RLFLIST?
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
     >    parameter file names and attributes in the current directory    $     `    instrSession                      '  `    status                             I      read_Files                         0    	            5        "num,a1,name1,a2,name2,...,a(num),name(num)"       CONTS

Continuous Mode Measure
Starting measurement in the continuous mode

Function: Starts measurement in the continuous mode.  That is, performs another measurement when one has completed.
Command:  CONTS
Query:    None
Response: None

Parameters:
          None

Description:
When MT8820A receives the next command during measurement started with the CONTS command, the measurement stops and processing for that command starts.


Sample programming
To start measurement in the continuous mode:
CONTS



Related commands
S1  Same function as CONTS.

Starts continuous sweep mode, but any further commands stop sweep if not completed, use SWP to synchronize a sweep     X    ViSession handle to the instrument
 Start the measurement in the continuous sweep mode     ?    Reports the status of this operation.
  for details see Init
    $     `    instrSession                     2 )  `    status                             0    	           1    S2

Single Mode Measure
Starting measurement in the single mode

Function: Starts measurement in single mode.
Command:  S2
Query:    None
Response: None

Parameters:
          None

Description:
When MT8820A receives the next command during measurement started with the S2 command, the measurement stops and processing for that command starts.  Pressing   switches the control to local mode.  To allow processing for the next command after measurement is over, use the SWP command.


Sample programming
To start measurement in the single mode:
S2



Related commands
SNGLS   Same function as S2
SWP Starts measurement in the synchronous single mode.
TS  Starts measurement in the synchronous single mode.

 
Starts a single sweep, but any further commands stop sweep if not completed, use SWP to synchronize a sweep     P    ViSession handle to the instrument

Start the measurement in single sweep mode     ?    Reports the status of this operation.
  for details see Init
   - $     `    instrSession                      )  `    status                             0    	           t    SCREEN

Screen
Setting the screen display On/Off

Function: Sets the screen display On/Off
Command:  SCREEN on_off
Query:    None
Response: on_off

Parameters:
          on_off  On/Off for screen display 

          ON  Screen display On
          OFF Screen display Off

          Initial value   ON


Sample programming
To set the screen display to Off:
SCREEN OFF

 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         Set the screen display on/off

mode is an int with these defined values

AUMT8820_SCREEN_MODE_ON      0
AUMT8820_SCREEN_MODE_OFF     1
    $     `    instrSession                      $  `    status                           7 z U       mode                               0    	                       ON 0 OFF 1        SERIAL?

Serial Number

Function: Inquires the serial number specific to MT8820A.
Command:  None
Query:    SERIAL?
Response: serial_number

Parameters:
          serial_number   Serial number


Sample programming
To query the serial number:
SERIAL?
 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
     %    Get the serial number of the MT8820    $     `    instrSession                      &  `    status                               d    serial_Number                      0    	                    "Serial number"   1    S2

Single Mode Measure
Starting measurement in the single mode

Function: Starts measurement in single mode.
Command:  S2
Query:    None
Response: None

Parameters:
          None

Description:
When MT8820A receives the next command during measurement started with the S2 command, the measurement stops and processing for that command starts.  Pressing   switches the control to local mode.  To allow processing for the next command after measurement is over, use the SWP command.


Sample programming
To start measurement in the single mode:
S2



Related commands
SNGLS   Same function as S2
SWP Starts measurement in the synchronous single mode.
TS  Starts measurement in the synchronous single mode.

 
Starts a single sweep, but any further commands stop sweep if not completed, use SWP to synchronize a sweep     O    ViSession handle to the instrument

Start a measurement in single sweep mode
     ?    Reports the status of this operation.
  for details see Init
   #< $     `    instrSession                     # "  `    status                             0    	               STDSEL

Select Standard
Selecting the measurement software

Function: Selects the measurement software.
Command:  STDSEL std
Query:    STDSEL?
Response: std

Parameters:
          WCDM    MX882000B W-CDMA Measurement Software
          GSM     MX882001A GSM Measurement Software
          CDMA2K  MX882002A CDMA2000 Measurement Software
          PDC     MX882004A PDC Measurement Software
        
Sample programming
To selest GSM for the measurement software to be used:
STDSEL GSM     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         standard is an int with these defined values

AUMT8820_STANDARD_SELECT_WCDMA    0
AUMT8820_STANDARD_SELECT_GSM      1
AUMT8820_STANDARD_SELECT_CDMA2K   2
AUMT8820_STANDARD_SELECT_PDC      3   &B $     `    instrSession                     &o *  `    status                           & l `       standard                           0    	                        W-CDMA 0 GSM 1 CDMA2000 2 PDC 3       STDSEL

Select Standard
Selecting the measurement software

Function: Selects the measurement software.
Command:  STDSEL std
Query:    STDSEL?
Response: std

Parameters:
          WCDM    MX882000B W-CDMA Measurement Software
          GSM     MX882001A GSM Measurement Software
          CDMA2K  MX882002A CDMA2000 Measurement Software
          PDC     MX882004A PDC Measurement Software
        
Sample programming
To selest GSM for the measurement software to be used:
STDSEL GSM     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         standard returns an int with these defined values

AUMT8820_STANDARD_SELECT_WCDMA    0
AUMT8820_STANDARD_SELECT_GSM      1
AUMT8820_STANDARD_SELECT_CDMA2K   2
AUMT8820_STANDARD_SELECT_PDC      3   *I $     `    instrSession                     *v (  `    status                           * z   `    standard                           0    	            	           Q    SVCD?

Save Directory Pass
Path to the parameter saving directory

Function: Queries the path to the directory in which the parameter file to be saved.
Command:  None
Query:    SVCD?
Response: dir_path

Parameters:
          dir_path    Path to the saving directory


Sample programming
To read the path to the saving directory:
SVCD?
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
     ,    the path to the parameter saving directory   - $     `    instrSession                     - %  `    status                           .  G      save_Directory                     0    	            '        "Path to the saving directory"   Y    SVDEFFILE?

Default File Name
Default name for parameter saving file

Function: Queries the file name to be automatically created when saving the setting parameters.
Command:  None
Query:    SVDEFFILE?
Response: fname

Parameters:
          fname   Saving file name


Sample programming
To query the default name for saving file:
SVDEFFILE?
 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
     N    the file name to be automatically created when saving the setting parameters   0 $     `    instrSession                     0 %  `    status                           0 {5       default_Name                       0    	                    "Saving file name"   P    SVFLIST

File List
Files stored in parameter saving directory

Function: Queries the names and attributes of the files stored in the parameter saving directory.
Command:  None
Query:    SVFLIST?
Response: num,a1,name1,a2,name2,...,a(num),name(num)

Parameters:
          num Total number of files (including the directory)

          a(x)    File attribute

          1   : Archive file (including files without attributes)
          2   : Read-only file

          name(x) Parameter file name (maximum of 255 characters)


Sample programming
To query a list of parameter files:
SVFLIST?
 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
     :    the parameter saving directory file names and attributes   4q $     `    instrSession                     4 $  `    status                           4  @      file_List                          0    	            5        "num,a1,name1,a2,name2,...,a(num),name(num)"       SWP

Synchronous Single Mode Measure
Starting measurement in the synchronous single mode.

Function: Starts measurement in the synchronous single mode.  Processing for the next command does not start before completion of the measurement, allowing synchronization between MT8820A and the controller.  Query inquires whether or not the measurement has been completed.
Command:  SWP
Query:    SWP?
Response: status

Parameters:
          status  Measurement status

          0   Measurement completed
          1   Measurement being performed

Description:
A measurement started with the SWP command does not process the query when read out the status during measurement.  Use the SNGLS command to process the query.


Sample programming
To start measurement in the synchronous single mode:
SWP



Related commands
TS  Same function as SWP (no query)
SNGLS   Starts measurement in the single mode
S2  Starts measurement in the single mode

     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
   9 $     `    instrSession                     9   `    status                             0    	               SWP

Synchronous Single Mode Measure
Starting measurement in the synchronous single mode.

Function: Starts measurement in the synchronous single mode.  Processing for the next command does not start before completion of the measurement, allowing synchronization between MT8820A and the controller.  Query inquires whether or not the measurement has been completed.
Command:  SWP
Query:    SWP?
Response: status

Parameters:
          status  Measurement status

          0   Measurement completed
          1   Measurement being performed

Description:
A measurement started with the SWP command does not process the query when read out the status during measurement.  Use the SNGLS command to process the query.


Sample programming
To start measurement in the synchronous single mode:
SWP



Related commands
TS  Same function as SWP (no query)
SNGLS   Starts measurement in the single mode
S2  Starts measurement in the single mode

     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         Get the synchronous single sweep mode

state returns an int with these defined values

AUMT8820_SYNCHRONOUS_SINGLE_SWEEP_COMPLETED      0
AUMT8820_SYNCHRONOUS_SINGLE_SWEEP_EXECUTING      1
   >f $     `    instrSession                     > '  `    status                           >    `    state                              0    	            	           y    TIME

Time
Setting the time

Function: Sets the time.  Query inquires the current time.
Command:  TIME hour,minute,second
Query:    TIME?
Response: hour,minute,second

Parameters:
          hour    Hour (Range = 0 to 23)

          minute  Minute (Range = 0 to 59)

          second  Second (Range = 0 to 59)


Sample programming
To set the time to 14:00:00:
TIME 14,00,00
 
     &    ViSession handle to the instrument

     ?    Reports the status of this operation.
  for details see Init
         hours

Range = 0 to 23         minutes

Range = 0 to 59         seconds

Range = 0 to 59   A $     `    instrSession                     B #  `    status                           BS `          hours                            Bs         minutes                          B         seconds                            0    	                                     ;                      ;                  w    TIME

Time
Setting the time

Function: Sets the time.  Query inquires the current time.
Command:  TIME hour,minute,second
Query:    TIME?
Response: hour,minute,second

Parameters:
          hour    Hour (Range = 0 to 23)

          minute  Minute (Range = 0 to 59)

          second  Second (Range = 0 to 59)


Sample programming
To set the time to 14:00:00:
TIME 14,00,00
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         hours (0-23)         minutes (0-59)         seconds (0-59)   E $     `    instrSession                     E #  `    status                           F	 x   `    hours                            F    `    minutes                          F7    `    seconds                            0    	            	            	            	               TITLE

Title
User-defined character string displayed at title

Function: Sets the user-defined character string displayed in the title section.
Command:  TITLE title
Query:    TITLE?
Response: title

Parameters:
          title   User-defined character string (maximum 25 characters)
          Initial value = "MT8820A"


Sample programming
To display "FIRST TEST":
TITLE "FIRST TEST"  /* Setting character string */
TTL USER    /* Displaying user-defined character string */
 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
     :    the user-defined character string displayed in the title   Iu $     `    instrSession                     I %  `    status                           I u    `    title                              0    	            
"MT8820A"       TITLE

Title
User-defined character string displayed at title

Function: Sets the user-defined character string displayed in the title section.
Command:  TITLE title
Query:    TITLE?
Response: title

Parameters:
          title   User-defined character string (maximum 25 characters)
          Initial value = "MT8820A"


Sample programming
To display "FIRST TEST":
TITLE "FIRST TEST"  /* Setting character string */
TTL USER    /* Displaying user-defined character string */
 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
     9    he user-defined character string displayed in the title   L $     `    instrSession                     L )  `    status                           MD z.       title                              0    	            (        "User-defined character string"   M    TMCNT?

Power On Time
Querying accumulated power-On time

Function: Queries the integrated power-on time.
Command:  None
Query:    TMCNT?
Response: time

Parameters:
          time    Accumulated time
                  Unit = s (second)
                  Resolution = 1


Sample programming
To query the accumulated time:
TMCNT?
 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
     <    Query the accumulated power-on time in minutes (res 1 min)   O $     `    instrSession                     O (  `    status                           P)    `    accumulated_Time                   0    	            	           +    TRM

GPIB Terminator

Function: Sets the code to be added at the end of a message received via GPIB.
Command:  TRM terminator,phone_no
Query:    TRM? phone_no
Response: terminator

Parameters:
          terminator  GPIB terminator

          0   :LF
          1   :CR/LF

          Initial value = 0

          phone_no    Phone under measurement (omittable)
(When omitted)  : Phone-1 
          1   : Phone-1 

Description:
This function is available only for remote control.


Sample programming
To set the GPIB terminator for Phone 1 to CR/LF:
TRM 1
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         Set the GPIB termination character(s)

terminator is an int with these defined values

AUMT8820_GPIB_TERMINATOR_LF      0
AUMT8820_GPIB_TERMINATOR_CR_LF   1
   S\ $     `    instrSession                     S %  `    status                           S { a       terminator                         0    	                       LF (0) 0 CR/LF (1) 1   -    TRM

GPIB Terminator

Function: Sets the code to be added at the end of a message received via GPIB.
Command:  TRM terminator,phone_no
Query:    TRM? phone_no
Response: terminator

Parameters:
          terminator  GPIB terminator

          0   :LF
          1   :CR/LF

          Initial value = 0

          phone_no    Phone under measurement (omittable)
(When omitted)  : Phone-1 
          1   : Phone-1 

Description:
This function is available only for remote control.


Sample programming
To set the GPIB terminator for Phone 1 to CR/LF:
TRM 1,1
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         Get the GPIB termination character(s)

terminator returns an int with these defined values

AUMT8820_GPIB_TERMINATOR_LF      0
AUMT8820_GPIB_TERMINATOR_CR_LF   1
   W $     `    instrSession                     W '  `    status                           W    `    terminator                         0    	            	               SWP

Synchronous Single Mode Measure
Starting measurement in the synchronous single mode.

Function: Starts measurement in the synchronous single mode.  Processing for the next command does not start before completion of the measurement, allowing synchronization between MT8820A and the controller.  Query inquires whether or not the measurement has been completed.
Command:  SWP
Query:    SWP?
Response: status

Parameters:
          status  Measurement status

          0   Measurement completed
          1   Measurement being performed

Description:
A measurement started with the SWP command does not process the query when read out the status during measurement.  Use the SNGLS command to process the query.


Sample programming
To start measurement in the synchronous single mode:
SWP



Related commands
TS  Same function as SWP (no query)
SNGLS   Starts measurement in the single mode
S2  Starts measurement in the single mode

     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
   ] $     `    instrSession                     ]= (  `    status                             0    	               TTL

Display Title
Title display type

Function: Sets the type of information to be displayed in the title display field.
Command:  TTL title_type
Query:    TTL?
Response: title_type

Parameters:
          title_type  Title display type

          USER    : User-defined character string
          DATE    : Date and time
          OFF : No display

          Initial value = DATE


Sample programming
To display a user-defined character string in the title display field:
TTL USER
 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         type is an int with these defined values

AUMT8820_TITLE_DISPLAY_TYPE_USER_TITLE      0
AUMT8820_TITLE_DISPLAY_TYPE_DATE_AND_TIME   1
AUMT8820_TITLE_DISPLAY_TYPE_NO_DISPLAY      2
   _ $     `    instrSession                     ` +  `    status                           `a l s       type                               0    	                      +User define 0 Date and time 1 No display 2       TTL

Display Title
Title display type

Function: Sets the type of information to be displayed in the title display field.
Command:  TTL title_type
Query:    TTL?
Response: title_type

Parameters:
          title_type  Title display type

          USER    : User-defined character string
          DATE    : Date and time
          OFF : No display

          Initial value = DATE


Sample programming
To display a user-defined character string in the title display field:
TTL USER
 
     %    ViSession handle to the instrument
     ?    Reports the status of this operation.
  for details see Init
         type returns an int with these defined values

AUMT8820_TITLE_DISPLAY_TYPE_USER_TITLE      0
AUMT8820_TITLE_DISPLAY_TYPE_DATE_AND_TIME   1
AUMT8820_TITLE_DISPLAY_TYPE_NO_DISPLAY      2
   c $     `    instrSession                     d$ %  `    status                           dk {   `    type                               0    	            	                                 K.        Init                                                                                                                                               &             K.        Close                                                                                                                                            'G  )             K.        Clear_Status                                                                                                                                     *6  0O             K.        Set_Standard_Event_Status_Enable                                                                                                                 1  74             K.        Get_Standard_Event_Status_Enable                                                                                                                 7  >             K.        Get_Standard_Event_Status_Register_Query                                                                                                         >  A             K.        Get_Identify_Query                                                                                                                               B  En             K.        Set_Operation_Complete                                                                                                                           E  I)             K.        Get_Operation_Complete                                                                                                                           I  M             K.        Reset                                                                                                                                            Nf  T;             K.        Set_Service_Request_Enable                                                                                                                       U  Z             K.        Get_Service_Request_Enable                                                                                                                       [  _             K.        Get_Status_Byte_Query                                                                                                                            `  aa             K.        Trigger                                                                                                                                          a  d             K.        Get_Self_Test                                                                                                                                    d  f             K.        Wait_To_Continue                                                                                                                                 gu  j             K.        Set_Alarm_Sound_Mode                                                                                                                             kq  n             K.        Get_Alarm_Sound_Mode                                                                                                                             od  r             K.        Set_Alarm_Sound_Mode                                                                                                                             s`  t             K.        Sound_Buzzer                                                                                                                                     u9  x{             K.        Continuous_Sweep_Mode                                                                                                                            x  {U             K.        Set_Date                                                                                                                                         |               K.        Get_Date                                                                                                                                         Y  5             K.        Set_Date_Mode                                                                                                                                    '               K.        Get_Date_Mode                                                                                                                                      	             K.        Set_Panel_Display_Mode                                                                                                                                          K.        Get_Panel_Display_Mode                                                                                                                             M             K.        Set_END_Event_Status_Enable_Register                                                                                                                            K.        Get_END_Event_Status_Enable_Register                                                                                                               N             K.        Set_ERR_Event_Status_Enable_Register                                                                                                                            K.        Get_ERR_Event_Status_Enable_Register                                                                                                                            K.        Get_END_Event_Status_Register_Query                                                                                                              Ƶ  ϖ             K.        Get_ERR_Event_Status_Register_Query                                                                                                              R  )             K.        Get_Full_Calibration_Time                                                                                                                        *  "             K.        Go_To_Local                                                                                                                                      ֝  ٹ             K.        Reset_To_Default                                                                                                                                 4  C             K.        Preset_To_System_Initialization                                                                                                                  ݾ               K.        Stop_Measurement                                                                                                                                                 K.        Preset_To_System_Initialization                                                                                                                  {  "             K.        Preset_To_Initialization_Level                                                                                                                     !             K.        Get_Parameters_By_Number                                                                                                                                        K.        Get_Parameters_By_Name                                                                                                                                          K.        Set_Parameters_By_Next_Number                                                                                                                                   K.        Set_Parameters_By_Number                                                                                                                                        K.        Set_Parameters_By_Name                                                                                                                           }               K.        Set_Reference_Frequency                                                                                                                           )             K.        Get_Reference_Frequency                                                                                                                                       K.        Set_RF_Signal_Output_Connector                                                                                                                  } 
I             K.        Get_RF_Signal_Output_Connector                                                                                                                   
0             K.        Get_Parameter_Directory_Query                                                                                                                   
 E             K.        Get_Parameter_Read_Directory_List                                                                                                               - y             K.        Continuous_Sweep_Mode                                                                                                                                         K.        Single_Sweep_Mode                                                                                                                               G              K.        Set_Screen_Mode                                                                                                                                  8             K.        Get_Serial_Number_Query                                                                                                                           #             K.        Single_Sweep_Mode                                                                                                                               $U '}             K.        Set_Standard_Select                                                                                                                             (\ +             K.        Get_Standard_Select                                                                                                                             ,E .F             K.        Get_Parameter_Save_Directory_Query                                                                                                              /  1K             K.        Get_Parameter_Default_Filename_Query                                                                                                            2 5'             K.        Get_Parameter_Save_Directory_List                                                                                                               6 :7             K.        Set_Synchronous_Single_Sweep                                                                                                                    : ?             K.        Get_Synchronous_Single_Sweep                                                                                                                    @] B             K.        Set_Time                                                                                                                                        D FO             K.        Get_Time                                                                                                                                        G J+             K.        Set_User_Title                                                                                                                                  J M             K.        Get_User_Title                                                                                                                                  N` Pm             K.        Get_Power_On_Time                                                                                                                               Q) Tw             K.        Set_GPIB_Terminator                                                                                                                             UK X             K.        Get_GPIB_Terminator                                                                                                                             Y\ ]             K.        Set_Synchronous_Single_Sweep                                                                                                                    ] a             K.        Set_Title_Display_Type                                                                                                                          b	 e.             K.        Get_Title_Display_Type                                                                                                                        C                                                                                     Initialize                                                                           Close                                                                                Clear Status (*CLS)                                                                  Standard Event Status Enable (*ESE)                                                  Standard Event Status Enable (*ESE?)                                                 Standard Event Status Register (*ESR?)                                               Identify Query (*IDN?)                                                               Operation Complete (*OPC)                                                            Operation Complete (*OPC?)                                                           Reset (*RST)                                                                         Service Request Enable (*SRE)                                                        Service Request Enable (*SRE?)                                                       Status Byte (*STB?)                                                                  Trigger (*TRG)                                                                       Self Test (*TST?)                                                                    Wait To Continue (*WAI)                                                              Alarm Sound Mode (ALARM)                                                             Alarm Sound Mode (ALARM?)                                                            Alarm Sound Mode (BEP)                                                               Sound Buzzer (BZR)                                                                   Continuous Sweep Mode (CONTS)                                                        Date (DATE)                                                                          Date (DATE?)                                                                         Date Mode (DATEMODE)                                                                 Date Mode (DATEMODE?)                                                                Panel Display Mode (DISPL)                                                           Panel Display Mode (DISPL?)                                                          END Event Status Enable Register (ESE2)                                              END Event Status Enable Register (ESE2?)                                             ERR Event Status Enable Register (ESE3)                                              ERR Event Status Enable Register (ESE3?)                                             END Event Status Register (ESR2?)                                                    ERR Event Status Register (ESR3?)                                                    Full CAL Time (FULLCAL_TM?)                                                          Go To Local (GTL)                                                                    Reset To Default (INI)                                                               Preset To System Initialization (IP)                                                 Stop Measurement (MEASSTOP)                                                          Preset To System Initialization (PRE)                                                Preset To Initialization Level (PRESET)                                              Parameters By Number (PRMRECALL)                                                     Parameters By Name (PRMRECALLNAME)                                                   Parameters By Next Number (PRMSAVE)                                                  Parameters By Number (PRMSAVE)                                                       Parameters By Name (PRMSAVENAME)                                                     Reference Frequency (REF)                                                            Reference Frequency (REF?)                                                           RF Signal Output Connector (RFOUT)                                                   RF Signal Output Connector (RFOUT?)                                                  Parameter Directory (RLCD?)                                                          Parameter Read Directory List (RLFLIST?)                                             Continuous Sweep Mode (S1)                                                           Single Sweep Mode (S2)                                                               Screen Mode (SCREEN)                                                                 Serial Number (SERIAL?)                                                              Single Sweep Mode (SNGLS)                                                            Standard Select (STDSEL)                                                             Standard Select (STDSEL?)                                                            Parameter Save Directory (SVCD?)                                                     Parameter Default Filename (SVDEFFILE?)                                              Parameter Save Directory List (SVFLIST?)                                             Synchronous Single Sweep (SWP)                                                       Synchronous Single Sweep (SWP?)                                                      Time (TIME)                                                                          Time (TIME?)                                                                         User Title (TITLE)                                                                   User Title (TITLE?)                                                                  Power On Time (TMCNT?)                                                               GPIB Terminator (TRM)                                                                GPIB Terminator (TRM?)                                                               Synchronous Single Sweep (TS)                                                        Title Display Type (TTL)                                                             Title Display Type (TTL?)                                                       